<?php
session_start();

if (!isset($_GET['id'])) {
    die("Invalid link");
}

$id = $_GET['id'];
$_SESSION["step1_token_$id"] = bin2hex(random_bytes(16));
?>
<!DOCTYPE html>
<html>
<head>
    <title>Step 1 - MgBee Unlock</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #0f172a 0, #020617 40%, #000 85%);
            color: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .card-wrap {
            position: relative;
            width: 100%;
            max-width: 420px;
        }

        .glow-ring {
            position: absolute;
            inset: -2px;
            border-radius: 20px;
            background: conic-gradient(from 120deg, #22c55e, #3b82f6, #a855f7, #22c55e);
            opacity: 0.75;
            filter: blur(10px);
            z-index: 0;
            animation: spinGlow 7s linear infinite;
        }

        @keyframes spinGlow {
            to { transform: rotate(360deg); }
        }

        .card {
            position: relative;
            z-index: 1;
            background: rgba(15, 23, 42, 0.96);
            border-radius: 18px;
            padding: 26px 24px 22px;
            border: 1px solid rgba(148, 163, 184, 0.12);
            box-shadow:
                0 20px 40px rgba(0, 0, 0, 0.75),
                0 0 0 1px rgba(15,23,42,0.9);
        }

        .badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: .18em;
            padding: 4px 10px;
            border-radius: 999px;
            border: 1px solid rgba(148,163,184,0.4);
            color: #a5b4fc;
            background: radial-gradient(circle at top left, rgba(59,130,246,0.3), transparent 60%);
        }

        .dot {
            width: 6px;
            height: 6px;
            border-radius: 999px;
            background: #22c55e;
            box-shadow: 0 0 8px #22c55e;
        }

        h2 {
            margin: 14px 0 8px;
            font-size: 22px;
            color: #f9fafb;
        }

        .sub {
            margin: 0 0 18px;
            font-size: 14px;
            color: #94a3b8;
        }

        .progress-wrap {
            margin: 12px 0 18px;
        }

        .progress-label {
            display: flex;
            justify-content: space-between;
            font-size: 11px;
            color: #9ca3af;
            margin-bottom: 4px;
        }

        .progress-bar {
            position: relative;
            width: 100%;
            height: 6px;
            border-radius: 999px;
            background: #020617;
            overflow: hidden;
            border: 1px solid #1f2937;
        }

        .progress-fill {
            position: absolute;
            inset: 0;
            width: 50%;
            background: linear-gradient(90deg, #22c55e, #3b82f6);
            box-shadow: 0 0 12px rgba(34,197,94,0.7);
            animation: pulseFill 1.4s ease-in-out infinite;
        }

        @keyframes pulseFill {
            0%   { transform: translateX(-50%) scaleX(0.7); opacity: 0.4; }
            50%  { transform: translateX(-5%)  scaleX(1.05); opacity: 1; }
            100% { transform: translateX(30%) scaleX(0.7); opacity: 0.4; }
        }

        .info-row {
            display: flex;
            justify-content: center;
            gap: 10px;
            font-size: 11px;
            color: #64748b;
            margin-bottom: 16px;
        }

        .info-tag {
            padding: 3px 8px;
            border-radius: 999px;
            background: #020617;
            border: 1px solid #1e293b;
        }

        .btn-primary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 11px 22px;
            border-radius: 999px;
            border: none;
            background: linear-gradient(90deg, #3b82f6, #22c55e);
            color: #f9fafb;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            cursor: pointer;
            box-shadow:
                0 0 18px rgba(59,130,246,0.65),
                0 0 26px rgba(34,197,94,0.55);
            transition: transform .15s ease, box-shadow .15s ease, filter .15s ease;
        }

        .btn-primary span.icon {
            font-size: 16px;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            filter: brightness(1.05);
            box-shadow:
                0 0 24px rgba(59,130,246,0.8),
                0 0 30px rgba(34,197,94,0.65);
        }

        .btn-primary:active {
            transform: translateY(0);
            box-shadow:
                0 0 14px rgba(59,130,246,0.6),
                0 0 20px rgba(34,197,94,0.45);
        }

        .foot {
            margin-top: 12px;
            font-size: 11px;
            color: #6b7280;
        }

        .secure-dot {
            display:inline-block;
            width:8px;height:8px;
            border-radius:999px;
            background:#22c55e;
            box-shadow:0 0 8px rgba(34,197,94,0.9);
            margin-right:4px;
        }
    </style>
</head>
<body>

<div class="card-wrap">
    <div class="glow-ring"></div>
    <div class="card">
        <div class="badge">
            <span class="dot"></span>
            STEP 1 OF 2
        </div>

        <h2>Prepare Unlock Session</h2>
        <p class="sub">
            We are creating a secure unlock session for your link. Continue to the next step to complete verification.
        </p>

        <div class="progress-wrap">
            <div class="progress-label">
                <span>Session status</span>
                <span>Ready</span>
            </div>
            <div class="progress-bar">
                <div class="progress-fill"></div>
            </div>
        </div>

        <div class="info-row">
            <div class="info-tag">Secure token generated</div>
            <div class="info-tag">Tracking disabled</div>
        </div>

        <!-- FRIENDLY URL: /unlock/ID?t=TOKEN -->
        <a href="/unlock/<?= htmlspecialchars($id, ENT_QUOTES) ?>?t=<?= urlencode($_SESSION["step1_token_$id"]) ?>" class="btn-primary">
            <span class="icon">⮞</span>
            <span>Continue to Step 2</span>
        </a>

        <div class="foot">
            <span class="secure-dot"></span> MgBee Gateway - Encrypted session continuity
        </div>
    </div>
</div>

</body>
</html>
