<?php
session_start();

if (!isset($_GET['id'], $_GET['t'])) {
    die("Invalid access");
}

$id = $_GET['id'];
$token_step1 = $_GET['t'];

if (!isset($_SESSION["step1_token_$id"]) || $token_step1 !== $_SESSION["step1_token_$id"]) {
    die("Unauthorized access");
}

$links = json_decode(file_get_contents("links.json"), true);
if (!isset($links[$id])) die("Invalid ID");

$_SESSION["step2_token_$id"] = bin2hex(random_bytes(16));
?>
<!DOCTYPE html>
<html>
<head>
    <title>Unlock Link - MgBee Gateway</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #020617 0, #000 65%);
            color: #e2e8f0;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            overflow: hidden; /* stop page shaking / scroll bar flicker */
        }

        .card-wrap {
            position: relative;
            width: 100%;
            max-width: 460px;
        }

        .glow-ring {
            position: absolute;
            inset: 0;
            border-radius: 22px;
            background: conic-gradient(from 210deg, #22c55e, #0ea5e9, #a855f7, #22c55e);
            opacity: 0.55;
            filter: blur(8px);
            z-index: 0;
            animation: spinGlow 8s linear infinite;
        }

        @keyframes spinGlow {
            to { transform: rotate(360deg); }
        }

        .card {
            position: relative;
            z-index: 1;
            background: rgba(15, 23, 42, 0.97);
            border-radius: 20px;
            padding: 26px 24px 22px;
            border: 1px solid rgba(148, 163, 184, 0.16);
            box-shadow:
                0 25px 50px rgba(0,0,0,0.9),
                0 0 0 1px rgba(15,23,42,0.9);
        }

        .badge {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: .18em;
            padding: 4px 10px;
            border-radius: 999px;
            border: 1px solid rgba(148,163,184,0.4);
            color: #fbbf24;
            background: radial-gradient(circle at top left, rgba(234,179,8,0.28), transparent 60%);
        }

        .dot {
            width: 6px;
            height: 6px;
            border-radius: 999px;
            background: #facc15;
            box-shadow: 0 0 8px #facc15;
        }

        h2 {
            margin: 14px 0 4px;
            font-size: 22px;
            color: #f9fafb;
        }

        .sub {
            margin: 0 0 16px;
            font-size: 14px;
            color: #94a3b8;
        }

        .timer-wrap {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 16px;
            margin-bottom: 16px;
        }

        .timer-circle {
            width: 50px;
            height: 50px;
            border-radius: 999px;
            border: 3px solid rgba(148,163,184,0.4);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }

        .timer-circle::before {
            content: "";
            position: absolute;
            inset: -25%;
            background: conic-gradient(#22c55e, #22c55e, transparent, transparent);
            animation: timerSpin 10s linear forwards; /* 10s to match countdown */
            transform-origin: center;
        }

        @keyframes timerSpin {
            from { transform: rotate(0deg); }
            to   { transform: rotate(360deg); }
        }

        .timer-inner {
            position: relative;
            z-index: 1;
            width: 36px;
            height: 36px;
            border-radius: 999px;
            background: #020617;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 17px;
            color: #38bdf8;
        }

        .timer-text {
            font-size: 13px;
            color: #9ca3af;
            text-align: left;
        }

        .timer-text strong {
            display:block;
            color:#e5e7eb;
            font-size:14px;
        }

        .progress-bar {
            width: 100%;
            height: 7px;
            border-radius: 999px;
            background: #020617;
            border: 1px solid #1f2937;
            overflow: hidden;
            margin: 4px 0 10px;
        }

        .progress-fill {
            height: 100%;
            width: 0%;
            background: linear-gradient(90deg, #22c55e, #3b82f6);
            box-shadow: 0 0 18px rgba(59,130,246,0.8);
            transition: width .2s ease-out;
        }

        .ad-label {
            margin-top: 6px;
            font-size: 11px;
            color: #64748b;
            text-align: left;
        }

        .ad-box {
            background: radial-gradient(circle at top, #020617 0, #020617 40%, #000 100%);
            border-radius: 16px;
            border: 1px solid #1f2937;
            height: 230px;
            margin: 14px 0 18px;
            display: flex;
            flex-direction: column;
            overflow: hidden;
            position: relative;
        }

        .ad-top {
            padding: 6px 10px;
            font-size: 11px;
            color: #9ca3af;
            display:flex;
            justify-content:space-between;
            align-items:center;
            border-bottom:1px solid #111827;
            background: linear-gradient(90deg, rgba(15,23,42,0.98), rgba(15,23,42,0.85));
        }

        .ad-body {
            flex: 1;
            display:flex;
            align-items:center;
            justify-content:center;
            color:#64748b;
            font-size:13px;
            padding:10px;
        }

        .ad-pulse {
            width: 10px;
            height: 10px;
            border-radius: 999px;
            background: #22c55e;
            box-shadow: 0 0 0 0 rgba(34,197,94,0.8);
            animation: pulseAd 1.4s infinite;
        }

        @keyframes pulseAd {
            0% { box-shadow: 0 0 0 0 rgba(34,197,94,0.7); }
            70% { box-shadow: 0 0 0 12px rgba(34,197,94,0); }
            100% { box-shadow: 0 0 0 0 rgba(34,197,94,0); }
        }

        #unlock {
            margin-top: 6px;
            text-align:center;
            display:none;
            min-height: 48px; /* reserve space to reduce layout jump */
        }

        .btn-primary {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            padding: 11px 24px;
            border-radius: 999px;
            border: none;
            background: linear-gradient(90deg, #22c55e, #16a34a);
            color: #f9fafb;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none;
            cursor: pointer;
            box-shadow:
                0 0 20px rgba(34,197,94,0.9),
                0 0 26px rgba(22,163,74,0.7);
            transition: transform .15s ease, box-shadow .15s ease, filter .15s ease;
        }

        .btn-primary span.icon {
            font-size: 16px;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            filter: brightness(1.05);
            box-shadow:
                0 0 24px rgba(34,197,94,1),
                0 0 32px rgba(22,163,74,0.8);
        }

        .btn-primary:active {
            transform: translateY(0);
            box-shadow:
                0 0 14px rgba(34,197,94,0.8),
                0 0 20px rgba(22,163,74,0.6);
        }

        .foot {
            margin-top: 12px;
            font-size: 11px;
            color: #6b7280;
            text-align:center;
        }

        .shield {
            display:inline-block;
            width:14px;
            height:14px;
            border-radius:4px;
            border:1px solid #22c55e;
            margin-right:4px;
            position:relative;
        }

        .shield::after {
            content:"";
            position:absolute;
            inset:3px;
            border-radius:2px;
            background:linear-gradient(135deg,#22c55e,#16a34a);
            opacity:0.4;
        }

        @media (max-width: 480px) {
            .card { padding: 22px 18px 20px; }
            .ad-box { height: 210px; }
        }
    </style>
    <script>
        const totalSeconds = 10;
        let sec = totalSeconds;

        function countdown(){
            updateTimerDisplay();
        }

        function updateTimerDisplay() {
            const timerSpan   = document.getElementById("timer");
            const progressFill = document.getElementById("progressFill");
            const unlockBox   = document.getElementById("unlock");

            if (!timerSpan || !progressFill) return;

            if (sec <= 0) {
                timerSpan.textContent = "0";
                progressFill.style.width = "100%";
                if (unlockBox) unlockBox.style.display = "block";
                return;
            }

            timerSpan.textContent = sec;

            const percent = ((totalSeconds - sec) / totalSeconds) * 100;
            progressFill.style.width = percent + "%";

            sec--;
            setTimeout(updateTimerDisplay, 1000);
        }
    </script>
</head>
<body onload="countdown()">

<div class="card-wrap">
    <div class="glow-ring"></div>
    <div class="card">
        <div class="badge">
            <span class="dot"></span>
            STEP 2 OF 2
        </div>

        <h2>Final Unlock Check</h2>
        <p class="sub">
            Please wait a few seconds while we verify your unlock gateway and prepare the final link.
        </p>

        <div class="timer-wrap">
            <div class="timer-circle">
                <div class="timer-inner" id="timer">10</div>
            </div>
            <div class="timer-text">
                <strong>Verification in progress</strong>
                Remaining time before unlock becomes available.
                <div class="progress-bar">
                    <div class="progress-fill" id="progressFill"></div>
                </div>
            </div>
        </div>

        <div class="ad-label">Sponsored placement</div>
        <div class="ad-box">
            <div class="ad-top">
                <span>Ad slot 300 x 250</span>
                <span class="ad-pulse"></span>
            </div>
            <div class="ad-body">
                Your advertisement can be placed here during the unlock countdown.
            </div>
        </div>

        <div id="unlock">
            <!-- FRIENDLY URL: /out/ID/TOKEN -->
            <a class="btn-primary" href="/out/<?= htmlspecialchars($id, ENT_QUOTES) ?>/<?= urlencode($_SESSION["step2_token_$id"]) ?>">
                <span class="icon">&#128275;</span>
                <span>Unlock Target Link</span>
            </a>
        </div>

        <div class="foot">
            <span class="shield"></span> MgBee Gateway - One-time secure redirect
        </div>
    </div>
</div>

</body>
</html>
